/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.ui.project;

import com.aptana.projects.ProjectData;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.wizards.IProjectWizardContributor;
import com.aptana.projects.wizards.ProjectWizardContributionManager;
import com.aptana.samples.ui.project.Messages;
import com.aptana.ui.IValidationPage;
import java.io.File;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

class SampleNewProjectCreationPage
extends WizardNewProjectCreationPage
implements IValidationPage {
    private ProjectData projectData;
    private String[] natures;
    private Set<IProjectWizardContributor> contributors;

    public SampleNewProjectCreationPage(String pageName, String[] natures) {
        super(pageName);
        this.natures = natures;
        this.projectData = new ProjectData();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        ProjectWizardContributionManager projectWizardContributionManager = this.getProjectWizardContributionManager();
        this.contributors = projectWizardContributionManager.contributeSampleProjectCreationPage(this.natures, (Object)this.projectData, (WizardPage)this, control);
        this.contributors.addAll(projectWizardContributionManager.contributeProjectCreationPage(this.natures, (Object)this.projectData, (WizardPage)this, control));
        this.validatePage();
    }

    protected ProjectWizardContributionManager getProjectWizardContributionManager() {
        return ProjectsPlugin.getDefault().getProjectWizardContributionManager();
    }

    protected ProjectData getProjectData() {
        return this.projectData;
    }

    public boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        IPath location = this.getLocationPath();
        if (this.useDefaults()) {
            location = location.append(this.getProjectName());
        }
        File file = location.toFile();
        boolean hasWarning = false;
        if (file.exists()) {
            this.setMessage(Messages.NewSampleProjectWizard_LocationExistsMessage, 2);
            hasWarning = true;
        }
        if (this.contributors != null) {
            for (IProjectWizardContributor contributor : this.contributors) {
                IStatus status = contributor.validateProjectCreationPage((Object)this.projectData);
                if (status == null) continue;
                if (status.getSeverity() == 4) {
                    this.setErrorMessage(status.getMessage());
                    return false;
                }
                if (hasWarning || status.getSeverity() != 2) continue;
                this.setMessage(status.getMessage(), 2);
                hasWarning = true;
            }
        }
        if (hasWarning) {
            return true;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

